/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.quantumdatasdk;

import com.quantumdata.quantumdatasdk.ChooseFileDialog;
import com.quantumdata.quantumdatasdk.ConfigData;
import com.quantumdata.quantumdatasdk.ExtensionFilter;
import com.quantumdata.quantumdatasdk.MainScreen;
import com.quantumdata.quantumdatasdk.QuantumDataSDK;
import com.quantumdata.quantumdatasdk.SDKFileEditorTab;
import com.quantumdata.quantumdatasdk.SDKFileEditorUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class SDKFileEditorManager
extends JPanel {
    private static final JTabbedPane pane = new JTabbedPane();
    private static int fileEditorNum = 0;
    private static String tabName;
    private File operatingFile = null;

    public SDKFileEditorManager(String string) {
        this.setLayout(new BorderLayout());
        tabName = string;
        this.setName(string);
        pane.removeAll();
        this.startNewFileEditor();
        pane.setTabLayoutPolicy(0);
        this.add(pane);
    }

    public void startNewFileEditor() {
        String string = "  " + tabName + " #" + fileEditorNum;
        ++fileEditorNum;
        SDKFileEditorTab sDKFileEditorTab = new SDKFileEditorTab();
        pane.addTab(string, null, sDKFileEditorTab, string);
        pane.setUI(new SDKFileEditorUI());
    }

    public void exitApp() {
        int n;
        boolean bl = false;
        for (n = 0; n < pane.getTabCount(); ++n) {
            SDKFileEditorTab sDKFileEditorTab = this.getTabHandler(n);
            if (sDKFileEditorTab == null || !sDKFileEditorTab.isSaveNeeded()) continue;
            bl = true;
            break;
        }
        if (bl && (n = JOptionPane.showConfirmDialog(this, "There are un-saved file(s) in the file editor\nDo you want to save them first?", "Prompt for unsaved files", 0)) == 0) {
            return;
        }
        QuantumDataSDK.ExitApp();
    }

    public void openFile() {
        File file = null;
        ChooseFileDialog chooseFileDialog = MainScreen.isScriptSDK ? new ChooseFileDialog("Open Script", "Open", "Open the script", 0, new ExtensionFilter(".cpp", "Script source files (*.cpp)"), this, new File(ConfigData.sUserScriptFileAbsoluteLocation + "*", "")) : new ChooseFileDialog("Open Image", "Open", "Open the image", 0, new ExtensionFilter(".cpp", "Image source files (*.cpp)"), this, new File(ConfigData.sUserImageFileAbsoluteLocation + "*", ""));
        file = chooseFileDialog.getFile();
        if (file != null) {
            ConfigData.updateUserFilePath(file.getAbsolutePath());
            this.openFileByName(file, false);
        }
    }

    public void openFileByName(File file, boolean bl) {
        if (ConfigData.sFileEditor.contentEquals("SDK Default Editor")) {
            if (!bl && this.fileAlreadyOpened(file, false)) {
                JOptionPane.showMessageDialog(this, "File \"" + file.getName() + "\" already being opend!");
            } else {
                SDKFileEditorTab sDKFileEditorTab = new SDKFileEditorTab(file);
                if (bl) {
                    String string = "Template " + ConfigData.getFileName(file);
                    pane.addTab(string, null, sDKFileEditorTab, file.getName());
                } else {
                    pane.addTab("  " + file.getName(), null, sDKFileEditorTab, file.getName());
                }
                pane.setUI(new SDKFileEditorUI());
            }
        } else {
            try {
                String string = ConfigData.sFileEditor + " " + file;
                Runtime.getRuntime().exec(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void newFileWithTemplate() {
        ChooseFileDialog chooseFileDialog = new ChooseFileDialog("Select Template", "Open", "Script Template", 0, new ExtensionFilter(".cpp", "Script template files (*.cpp)"), this, new File(ConfigData.sScriptTemplateAbsoluteDirectory + "*", ""));
        File file = chooseFileDialog.getFile();
        if (file != null) {
            this.openFileByName(file, true);
        }
    }

    public void closeTabAt(int n) {
        SDKFileEditorTab sDKFileEditorTab = this.getTabHandler(n);
        if (sDKFileEditorTab != null) {
            if (sDKFileEditorTab.isSaveNeeded()) {
                Object[] objectArray = new Object[]{"Yes", "No", "Cancel"};
                int n2 = JOptionPane.showOptionDialog(this, "There are un-saved changes in this file!\nDo you want to save it first?", "Prompt for unsaved changes", 1, 3, null, objectArray, objectArray[0]);
                if (n2 == 0) {
                    this.saveFile();
                    pane.remove(n);
                } else if (n2 == 1) {
                    pane.remove(n);
                }
            } else {
                pane.remove(n);
            }
        }
    }

    public void closeFile() {
        if (pane.getTabCount() == 0) {
            JOptionPane.showMessageDialog(this, "There is NO file need to be closed!");
        } else {
            this.closeTabAt(pane.getSelectedIndex());
        }
    }

    public void saveFile() {
        if (pane.getTabCount() == 0) {
            JOptionPane.showMessageDialog(this, "There is NO file need to be saved!");
        } else {
            String string = pane.getTitleAt(pane.getSelectedIndex());
            if (string.endsWith(".cpp")) {
                SDKFileEditorTab sDKFileEditorTab = this.getCurrentTabHandler();
                if (sDKFileEditorTab != null) {
                    sDKFileEditorTab.saveFile();
                }
            } else {
                this.saveFileAs();
            }
        }
    }

    public void saveFileAs() {
        if (pane.getTabCount() == 0) {
            JOptionPane.showMessageDialog(this, "There is NO file need to be saved!");
        } else {
            SDKFileEditorTab sDKFileEditorTab = this.getCurrentTabHandler();
            if (sDKFileEditorTab != null) {
                File file;
                File file2 = null;
                ChooseFileDialog chooseFileDialog = MainScreen.isScriptSDK ? new ChooseFileDialog("Save Script", "Save", "Save the script", 0, new ExtensionFilter(".cpp", "Script source files (*.cpp)"), this, new File(ConfigData.sUserScriptFileAbsoluteLocation + "*", "")) : new ChooseFileDialog("Save Image", "Save", "Save the image", 0, new ExtensionFilter(".cpp", "Image source files (*.cpp)"), this, new File(ConfigData.sUserImageFileAbsoluteLocation + "*", ""));
                file2 = chooseFileDialog.getFile();
                if (file2 == null) {
                    return;
                }
                this.operatingFile = !file2.getAbsolutePath().endsWith(".cpp") ? (file = new File(file2.getAbsolutePath().concat(".cpp"))) : file2;
                if (this.operatingFile == null) {
                    return;
                }
                ConfigData.updateUserFilePath(this.operatingFile.getAbsolutePath());
                if (this.operatingFile.exists()) {
                    int n = JOptionPane.showConfirmDialog(this, this.operatingFile.getName() + " exists.  Overwrite?", "Confirm Save", 0, 2);
                    if (n == 0) {
                        this.fileAlreadyOpened(this.operatingFile, true);
                    } else {
                        return;
                    }
                }
                if (sDKFileEditorTab.saveToAnotherFile(this.operatingFile)) {
                    pane.setTitleAt(pane.getSelectedIndex(), "  " + sDKFileEditorTab.getFileName());
                }
            }
        }
    }

    private boolean fileAlreadyOpened(File file, boolean bl) {
        boolean bl2 = false;
        for (int i = 0; i < pane.getComponentCount(); ++i) {
            if (!file.getName().equalsIgnoreCase(this.getTabHandler(i).getFileName())) continue;
            bl2 = true;
            if (!bl) break;
            this.closeTabAt(i);
            break;
        }
        return bl2;
    }

    public SDKFileEditorTab getCurrentTabHandler() {
        return this.getTabHandler(pane.getSelectedIndex());
    }

    private SDKFileEditorTab getTabHandler(int n) {
        Component component = pane.getComponent(n);
        if (component instanceof SDKFileEditorTab) {
            return (SDKFileEditorTab)component;
        }
        return null;
    }

    static String getScriptFilename() {
        return "default.cpp";
    }

    public static JTabbedPane getPanel() {
        return pane;
    }

    public boolean validFileTab() {
        if (pane.getTabCount() == 0) {
            JOptionPane.showMessageDialog(this, "Please open a valid script file first!");
            return false;
        }
        return true;
    }
}

